package gov.va.med.mhv.sm.admin.enums;

import java.util.Comparator;

public enum ListsSubCategoryEnum {

	ACTION_PENDING_PATIENTS (0, "Action Pending Patients", "Patients have not yet opted in to use SM, and have not opted out."),
	ASSOCIATED_PATIENTS (1, "Associated Patients", "Patients are associated with a Healthcare Team."),
	BLOCKED_PATIENTS (2, "Blocked Patients", "A blocked patient has been prevented from using SM based on SM policy. This is performed by a SM Administrator."),
	CPRS_TIU_PROGRESS_NOTE_FAILURE (3, "CPRS TIU Progress Note Failure", "Instances in which attempts to save message contents as a TIU Progress Note in CPRS are not successful."),
	OPTED_IN_PATIENTS (4, "Opted In Patients", "Patients opt in when they agree to the terms of SM use. This is required to send or receive a message."),
	OPTED_OUT_PATIENTS (5, "Opted Out Patients", "Patients opt out when they decline the terms of SM use, and can no longer send or receive a message."),
	SM_HEALTHCARE_TEAMS (6, "SM Healthcare Teams", "Display of SM Healthcare Team Name(s)"),
	SM_HEALTHCARE_TEAM_MEMBERS (7, "SM Healthcare Team Members", "List of SM Healthcare Team members");
	
	private int id;
	private String name;
	private String longDescription;
	
	private ListsSubCategoryEnum(int id, String description, String longDescription){
		this.id = id;
		this.name = description;
		this.longDescription = longDescription;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	
	public String getLongDescription() {
		return longDescription;
	}
	
	public void setLongDescription(String longDescription) {
		this.longDescription = longDescription;
	}
	
	public static ListsSubCategoryEnum valueOf(int value){
		for(ListsSubCategoryEnum f : ListsSubCategoryEnum.values()){
			if(f.getId() == value)
				return f;
		}
		/* none found; throw error */
		throw new RuntimeException("no ListsSubCategoryEnum type found for " + value);
	}
	
	public static final Comparator<ListsSubCategoryEnum> LISTS_SUBCATEGORY_SORTER = new Comparator<ListsSubCategoryEnum>() {
		public int compare(ListsSubCategoryEnum a, ListsSubCategoryEnum b) {
			String a1 = a.getName();
			String b1 = b.getName();
			if(a1 == null || b1 == null) return 0;
			return a1.compareToIgnoreCase(b1);
		}
	};
	
}
